/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.dnd;

 
/**
 * The <code>TransferData</code> class is a platform specific data structure for
 * describing the type and the contents of data being converted by a transfer agent.
 *
 * <p>As an application writer, you do not need to know the specifics of 
 * TransferData.  TransferData instances are passed to a subclass of Transfer 
 * and the Transfer object manages the platform specific issues.  
 * You can ask a Transfer subclass if it can handle this data by calling 
 * Transfer.isSupportedType(transferData).</p>
 *
 * <p>You should only need to become familiar with the fields in this class if you 
 * are implementing a Transfer subclass and you are unable to subclass the 
 * ByteArrayTransfer class.</p>
 */
public class TransferData {
	/**
	 * The type is a unique identifier of a system format or user defined format.
	 * (Warning: This field is platform dependent)
	 */
	public int type;
	
	/**
	 * Pointer to the data being transferred.  Data is of size 
	 * <code>length</code> bytes.
	 * (Warning: This field is platform dependent)
	 */
	public int pData;
	
	/**
	 * Specifies the number of bytes in pValue.
	 * (Warning: This field is platform dependent)
	 */
	public int length;
	
	/**
	 * The result field contains the result of converting a java data type
	 * into a platform specific value.
	 * (Warning: This field is platform dependent)
	 * 
 	 * <p>The value of result is 1 if the conversion was successfully.  The value of 
	 * result is 0 if the conversion failed.</p>
	 */
	public int result;
}
